﻿using System;
using System.Security.Cryptography;
using System.Text;
using System.Windows.Forms;

namespace Percent___Qualification_work.Classes
{
    public class Authentication
    {
        // Singleton instance
        private static Authentication _instance;
        private static readonly object _lock = new object();

        // Static properties to hold active session details
        public static string ActiveUser { get; private set; }
        public static int ActiveUserID { get; private set; }

        // Private constructor to prevent external instantiation
        private Authentication() { }

        // Public property to get the singleton instance
        public static Authentication Instance
        {
            get
            {
                lock (_lock)
                {
                    if (_instance == null)
                    {
                        _instance = new Authentication();
                    }
                    return _instance;
                }
            }
        }

        // Login function that checks credentials
        public bool Login(string username, string password)
        {
            try
            {
                string storedHashedPassword = DatabaseConnection.Instance.GetPasswordForUser(username);
                int id = DatabaseConnection.Instance.GetUserID(username);

                if (!string.IsNullOrEmpty(storedHashedPassword))
                {
                    string hashedInputPassword = HashPassword(password);

                    if (storedHashedPassword == hashedInputPassword)
                    {
                        ActiveUser = username;
                        ActiveUserID = id;
                        return true;
                    }
                    else
                    {
                        MessageBox.Show("Incorrect username or password.");
                        return false;
                    }
                }
                else
                {
                    MessageBox.Show("Incorrect username or password.");
                    return false;
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error: " + ex.Message);
                return false;
            }
        }

        // Register a new user
        public bool Register(string username, string password)
        {
            if (DatabaseConnection.Instance.IsUsernameTaken(username))
            {
                MessageBox.Show("Username already taken.");
                return false;
            }

            string hashedPassword = HashPassword(password);
            return DatabaseConnection.Instance.AddUser(username, hashedPassword);
        }

        public static void Logout()
        {
            ActiveUser = null;
            ActiveUserID = 0;
        }

        // Hash the password using SHA256
        private string HashPassword(string password)
        {
            using (SHA256 sha256 = SHA256.Create())
            {
                byte[] bytes = sha256.ComputeHash(Encoding.UTF8.GetBytes(password));
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i < bytes.Length; i++)
                {
                    builder.Append(bytes[i].ToString("x2"));
                }
                return builder.ToString();
            }
        }
    }
}
